/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.lpar;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.fsp.FSPCmdMgr;
import com.ibm.hsc.fsp.cmdhelpers.FspCmdHelper;
import com.ibm.hsc.fsp.cmdhelpers.FspVioScsiConfig;
import com.ibm.hsc.fsp.cmdhelpers.VioSlotState;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.lpar.OmLparMgr;
import com.ibm.hsc.objmgr.lpar.OmLparVscsiUpdater;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.RObjectId;
import com.ibm.hsc.rep.v50.R50Define;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class OmLparVserialUpdater {
    private OmLparMgr mLparMgr;
    private OmCecMgr mCecMgr;
    private RObject mLparObj;
    private RObjectId mLparOid;
    private int updateFlag = 0;
    private FspCmdHelper mCmdHelper;
    private FSPCmdMgr mCmdMgr;

    public OmLparVserialUpdater(OmLparMgr omLparMgr) {
        this.mLparMgr = omLparMgr;
        this.mLparObj = this.mLparMgr.getObject();
        this.mLparOid = this.mLparMgr.getObjectId();
        this.mCecMgr = this.mLparMgr.getCecMgr();
        this.mCmdHelper = this.mCecMgr.getCmdHelper();
        this.mCmdMgr = this.mCecMgr.getCmdMgr();
    }

    public void update(Hashtable hashtable) throws RException, PIHscServerException, PIHscCmdMgrException {
        Object object;
        Object object2;
        RObject rObject;
        Object object3;
        Object object4;
        Enumeration<Object> enumeration;
        Vector vector = this.mLparObj.associators(R50Define.AID_IBMHSC_LparVirtualSerial);
        if (vector != null) {
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object4 = (RObject)enumeration.nextElement();
                object3 = (String)((RObject)object4).getProperty("Name");
                rObject = new UnsignedInt16((String)object3);
                object2 = (VioSlotState)hashtable.get(rObject);
                if (object2 == null) {
                    this.deleteVserial((RObject)object4);
                    continue;
                }
                object = this.mCmdHelper.getVirtualScsiSerialConfig(new UnsignedInt16(this.mLparMgr.getLparIndex()), (UnsignedInt16)rObject);
                if (this.updateVserialInstance((RObject)object4, (FspVioScsiConfig)object, (VioSlotState)object2)) {
                    // empty if block
                }
                hashtable.remove(rObject);
            }
        }
        enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            object4 = (VioSlotState)enumeration.nextElement();
            object3 = ((VioSlotState)object4).slotNumber;
            rObject = OmLparVscsiUpdater.getSameSlotNum(object3, this.mLparMgr.getLparName());
            if (rObject != null) {
                OmLparVscsiUpdater.deleteVslotWithDiffType(rObject, this.mLparMgr);
                continue;
            }
            object2 = new RObjectId(1, R50Define.CID_IBMHSC_VirtualSerial);
            ((RObjectId)object2).setKeyValue(0, "IBMHSC_VirtualSerial");
            ((RObjectId)object2).setKeyValue(1, ((VioSlotState)object4).slotNumber.toString());
            ((RObjectId)object2).setKeyValue(2, "IBMHSC_Partition");
            ((RObjectId)object2).setKeyValue(3, this.mLparMgr.getLparName());
            object = new RObject((RObjectId)object2);
            ((RObject)object).addInstance();
            ((RObject)object).addAssociation(R50Define.AID_IBMHSC_LparVirtualSerial, this.mLparOid);
            FspVioScsiConfig fspVioScsiConfig = this.mCmdHelper.getVirtualScsiSerialConfig(new UnsignedInt16(this.mLparMgr.getLparIndex()), ((VioSlotState)object4).slotNumber);
            System.out.println("lpar id = " + this.mLparMgr.getLparName() + "virtual slot = " + ((VioSlotState)object4).slotNumber + " verserialConfig = " + fspVioScsiConfig);
            this.updateVserialInstance((RObject)object, fspVioScsiConfig, (VioSlotState)object4);
        }
        System.out.println("client table = " + this.mCecMgr.getClientAdaptersTable());
        System.out.println("server table = " + this.mCecMgr.getServerAdaptersTable());
        System.out.println("incompatible client table = " + this.mCecMgr.getIncompatibleClients());
    }

    private boolean updateVserialInstance(RObject rObject, FspVioScsiConfig fspVioScsiConfig, VioSlotState vioSlotState) throws RException {
        String string;
        int n;
        boolean bl = false;
        UnsignedInt8 unsignedInt8 = (UnsignedInt8)rObject.getProperty("DeviceAttribute");
        int n2 = n = fspVioScsiConfig.getVirtDeviceAttr().intValue();
        if (unsignedInt8 != null) {
            n2 = unsignedInt8.intValue();
        }
        String string2 = (String)rObject.getProperty("Name");
        System.out.println("updateVserialInstance slotID = " + string2 + " oldDeviceAttr = " + n2 + " newDeviceAttr = " + n);
        if (n2 == 1) {
            if (n == n2) {
                if (this.updateVserialProperties(rObject, fspVioScsiConfig, vioSlotState)) {
                    bl = true;
                }
                return this.updateVserialToClientAssoc(rObject, fspVioScsiConfig) || bl;
            }
            return this.convertVserialServToClient(rObject, fspVioScsiConfig, vioSlotState);
        }
        if (n == n2) {
            if (this.updateVserialProperties(rObject, fspVioScsiConfig, vioSlotState)) {
                bl = true;
            }
            return this.updateVserialToServAssoc(rObject, fspVioScsiConfig) || bl;
        }
        String string3 = String.valueOf(this.mLparMgr.getLparIndex());
        string3 = string3 + "*" + string2;
        Hashtable hashtable = this.mCecMgr.getClientAdaptersTable();
        Hashtable hashtable2 = this.mCecMgr.getServerAdaptersTable();
        Vector vector = (Vector)hashtable2.get(string = (String)hashtable.get(string3));
        if (vector != null) {
            vector.remove(string3);
        }
        rObject.deleteAssociationsByLink(242);
        Hashtable hashtable3 = this.mCecMgr.getIncompatibleClients();
        hashtable3.remove(string3);
        this.updateVserialProperties(rObject, fspVioScsiConfig, vioSlotState);
        this.updateVserialToClientAssoc(rObject, fspVioScsiConfig);
        return true;
    }

    private boolean updateVserialProperties(RObject rObject, FspVioScsiConfig fspVioScsiConfig, VioSlotState vioSlotState) throws RException {
        UnsignedInt8 unsignedInt8 = fspVioScsiConfig.getVirtDeviceAttr();
        UnsignedInt8 unsignedInt82 = fspVioScsiConfig.getSupportHmcClient();
        boolean bl = false;
        if (rObject.setProperty("DeviceAttribute", (Object)unsignedInt8)) {
            bl = true;
        }
        if (rObject.setProperty("SupportHMC", (Object)unsignedInt82)) {
            bl = true;
        }
        if (rObject.setProperty("Required", (Object)new Boolean(fspVioScsiConfig.isRequired()))) {
            bl = true;
        }
        if (rObject.setProperty("DrcIndex", (Object)fspVioScsiConfig.getDrcIndex())) {
            bl = true;
        }
        if (rObject.setProperty("DrcName", (Object)fspVioScsiConfig.getDrcName())) {
            bl = true;
        }
        if (rObject.setProperty("RemoteLparID", (Object)fspVioScsiConfig.getServerLparId())) {
            bl = true;
        }
        if (rObject.setProperty("RemoteSlotID", (Object)fspVioScsiConfig.getServerVirtSlotNum())) {
            bl = true;
        }
        if (rObject.setProperty("CurLockOwnerClass", (Object)vioSlotState.curLockOwnerClass)) {
            bl = true;
        }
        if (rObject.setProperty("CurLockOwnerId", (Object)vioSlotState.currentSlotLockOwner)) {
            bl = true;
        }
        if (rObject.setProperty("PendLockOwnerClass", (Object)vioSlotState.pendLockOwnerClass)) {
            bl = true;
        }
        if (rObject.setProperty("PendLockOwnerId", (Object)vioSlotState.pendingSlotLockOwner)) {
            bl = true;
        }
        return bl;
    }

    private boolean updateVserialToServAssoc(RObject rObject, FspVioScsiConfig fspVioScsiConfig) throws RException {
        Cloneable cloneable;
        Vector vector;
        int n;
        boolean bl = false;
        String string = this.mCecMgr.getCecName();
        UnsignedInt16 unsignedInt16 = fspVioScsiConfig.getServerLparId();
        UnsignedInt16 unsignedInt162 = fspVioScsiConfig.getServerVirtSlotNum();
        String string2 = (String)rObject.getProperty("Name");
        String string3 = String.valueOf(this.mLparMgr.getLparIndex());
        string3 = string3 + "*" + string2;
        Hashtable hashtable = this.mCecMgr.getClientAdaptersTable();
        String string4 = (String)hashtable.get(string3);
        System.out.println("serverKey = " + string4);
        String string5 = unsignedInt16.toString() + "*" + unsignedInt162.toString();
        String string6 = null;
        String string7 = null;
        if (string4 != null && string4.length() > 0) {
            n = string4.indexOf(42);
            string6 = string4.substring(0, n);
            string7 = string4.substring(n + 1);
            if (Integer.parseInt(string6) == unsignedInt16.intValue() && Integer.parseInt(string7) == unsignedInt162.intValue()) {
                return false;
            }
        }
        n = 0;
        if (string4 != null && string4.length() > 0) {
            n = OmLparVscsiUpdater.isCompatible(rObject, unsignedInt16.toString(), unsignedInt162.toString(), this.mCecMgr, this.mLparMgr) ? 1 : 0;
        }
        hashtable.put(string3, string5);
        Hashtable hashtable2 = this.mCecMgr.getServerAdaptersTable();
        if (string4 != null && string4.length() > 0) {
            vector = (Vector)hashtable2.get(string4);
            if (vector != null) {
                vector.remove(string3);
            }
            if ((cloneable = rObject.associatorsByLink(242)) != null && ((Vector)cloneable).size() > 0) {
                bl = true;
            }
        }
        if ((vector = (Vector)hashtable2.get(string5)) == null) {
            vector = new Vector();
        }
        vector.add(string3);
        hashtable2.put(string5, vector);
        cloneable = this.mCecMgr.getIncompatibleClients();
        if (n != 0) {
            ((Hashtable)cloneable).remove(string3);
            RObjectId rObjectId = new RObjectId(1, R50Define.CID_IBMHSC_VirtualSerial);
            rObjectId.setKeyValue(0, "IBMHSC_VirtualSerial");
            rObjectId.setKeyValue(1, unsignedInt162);
            rObjectId.setKeyValue(2, "IBMHSC_Partition");
            rObjectId.setKeyValue(3, unsignedInt16 + "*" + string);
            rObject.addAssociationByLink(242, rObjectId);
            bl = true;
        } else {
            ((Hashtable)cloneable).put(string3, string5);
        }
        return bl;
    }

    private boolean updateVserialToClientAssoc(RObject rObject, FspVioScsiConfig fspVioScsiConfig) throws RException {
        boolean bl = false;
        String string = this.mCecMgr.getCecName();
        Hashtable hashtable = this.mCecMgr.getServerAdaptersTable();
        String string2 = (String)rObject.getProperty("Name");
        String string3 = String.valueOf(this.mLparMgr.getLparIndex());
        string3 = string3 + "*" + string2;
        Vector vector = (Vector)hashtable.get(string3);
        System.out.println("server lpar slot num = " + string3 + " client list = " + vector);
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            Hashtable hashtable2 = this.mCecMgr.getIncompatibleClients();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                int n = string4.indexOf(42);
                String string5 = string4.substring(0, n);
                String string6 = string4.substring(n + 1);
                RObject rObject2 = OmLparVscsiUpdater.getSameSlotNum(new UnsignedInt16(string6), string5 + "*" + string);
                System.out.println("clientObj = " + rObject2);
                RObjectId rObjectId = null;
                boolean bl2 = false;
                if (rObject2 != null) {
                    bl2 = OmLparVscsiUpdater.isCompatible(rObject, string5, string6, this.mCecMgr, this.mLparMgr);
                    rObjectId = rObject2.getObjectId();
                }
                System.out.println("compatible = " + bl2);
                if (bl2) {
                    hashtable2.remove(string4);
                    if (rObject.hasAssociationByLink(241, rObjectId)) continue;
                    rObject.addAssociationByLink(241, rObjectId);
                    bl = true;
                    continue;
                }
                hashtable2.put(string4, string3);
                if (rObjectId == null || !rObject.hasAssociationByLink(241, rObjectId)) continue;
                rObject.deleteAssociationByLink(241, rObjectId);
                bl = true;
            }
        } else {
            Vector vector2 = rObject.associatorsByLink(241);
            rObject.deleteAssociationsByLink(241);
            if (vector2 != null && vector2.size() > 0) {
                bl = true;
            }
        }
        return bl;
    }

    public void deleteVserial(RObject rObject) throws RException {
        if (rObject != null) {
            String string = (String)rObject.getProperty("SystemName");
            String string2 = string.substring(0, string.indexOf(42));
            String string3 = (String)rObject.getProperty("Name");
            String string4 = string2 + "*" + string3;
            UnsignedInt8 unsignedInt8 = (UnsignedInt8)rObject.getProperty("DeviceAttribute");
            if (unsignedInt8.intValue() == 0) {
                Hashtable hashtable;
                Hashtable hashtable2 = this.mCecMgr.getClientAdaptersTable();
                String string5 = (String)hashtable2.get(string4);
                if (string5 != null) {
                    hashtable = this.mCecMgr.getServerAdaptersTable();
                    Vector vector = (Vector)hashtable.get(string5);
                    vector.remove(string4);
                }
                hashtable2.remove(string4);
                hashtable = this.mCecMgr.getIncompatibleClients();
                hashtable.remove(string4);
            } else {
                Hashtable hashtable = this.mCecMgr.getServerAdaptersTable();
                Vector vector = (Vector)hashtable.get(string4);
                if (vector != null) {
                    Enumeration enumeration = vector.elements();
                    Hashtable hashtable3 = this.mCecMgr.getIncompatibleClients();
                    while (enumeration.hasMoreElements()) {
                        String string6 = (String)enumeration.nextElement();
                        hashtable3.put(string6, string4);
                    }
                }
            }
            rObject.deleteInstance();
        }
    }

    private boolean convertVserialServToClient(RObject rObject, FspVioScsiConfig fspVioScsiConfig, VioSlotState vioSlotState) throws RException {
        Cloneable cloneable;
        boolean bl = false;
        String string = (String)rObject.getProperty("Name");
        Hashtable hashtable = this.mCecMgr.getServerAdaptersTable();
        String string2 = String.valueOf(this.mLparMgr.getLparIndex());
        Vector vector = (Vector)hashtable.get(string2 = string2 + "*" + string);
        if (vector != null) {
            cloneable = this.mCecMgr.getIncompatibleClients();
            for (int i = 0; i < vector.size(); ++i) {
                ((Hashtable)cloneable).put(vector.elementAt(i), string2);
            }
        }
        cloneable = rObject.associatorsByLink(241);
        rObject.deleteAssociationsByLink(241);
        if (cloneable != null && ((Vector)cloneable).size() > 0) {
            bl = true;
        }
        if (this.updateVserialProperties(rObject, fspVioScsiConfig, vioSlotState)) {
            bl = true;
        }
        if (this.updateVserialToServAssoc(rObject, fspVioScsiConfig)) {
            bl = true;
        }
        return bl;
    }

    private boolean convertVserialClientToServ(RObject rObject, FspVioScsiConfig fspVioScsiConfig, VioSlotState vioSlotState) throws RException {
        Cloneable cloneable;
        String string;
        boolean bl = false;
        String string2 = (String)rObject.getProperty("Name");
        String string3 = String.valueOf(this.mLparMgr.getLparIndex());
        string3 = string3 + "*" + string2;
        Hashtable hashtable = this.mCecMgr.getClientAdaptersTable();
        Hashtable hashtable2 = this.mCecMgr.getServerAdaptersTable();
        Vector vector = (Vector)hashtable2.get(string = (String)hashtable.get(string3));
        if (vector != null) {
            vector.remove(string3);
            cloneable = rObject.associatorsByLink(242);
            rObject.deleteAssociationsByLink(242);
            if (cloneable != null && ((Vector)cloneable).size() > 0) {
                bl = true;
            }
        }
        cloneable = this.mCecMgr.getIncompatibleClients();
        ((Hashtable)cloneable).remove(string3);
        if (this.updateVserialProperties(rObject, fspVioScsiConfig, vioSlotState)) {
            bl = true;
        }
        if (this.updateVserialToClientAssoc(rObject, fspVioScsiConfig)) {
            bl = true;
        }
        return bl;
    }
}

